package dk.clondyke.fsxveg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class SeasonalFileSet {

	private File defaultFile = null;
	private File summerFile = null;
	private File winterFile = null;
	private File hardWinterFile = null;
	private File fallFile = null;
	private File springFile = null;

	public SeasonalFileSet() {
		
	}

	
	public File getDefaultFile() {
		return defaultFile;
	}

	public void setDefaultFile(File defaultFile) {
		this.defaultFile = defaultFile;
	}
	
	public boolean defaultFileHasSuffix() {
		boolean suffixFound = false;

		if (defaultFile == null) {
			suffixFound = true;
		} else {
			String name = defaultFile.getName().toLowerCase();
			if (name.substring(name.length()-6).equals("_su.bgl")
				|| name.substring(name.length()-6).equals("_wi.bgl")
				|| name.substring(name.length()-6).equals("_hw.bgl")
				|| name.substring(name.length()-6).equals("_fa.bgl")
				|| name.substring(name.length()-6).equals("_sp.bgl")) {
				suffixFound = true;
			}
		}
		
		return suffixFound;
	}

	public File getSummerFile() {
		return summerFile;
	}

	public void setSummerFile(File summerFile) {
		this.summerFile = summerFile;
	}
	
	public File getWinterFile() {
		return winterFile;
	}
	
	public void setWinterFile(File winterFile) {
		this.winterFile = winterFile;
	}

	public File getHardWinterFile() {
		return hardWinterFile;
	}

	public void setHardWinterFile(File hardWinterFile) {
		this.hardWinterFile = hardWinterFile;
	}

	public File getFallFile() {
		return fallFile;
	}

	public void setFallFile(File fallFile) {
		this.fallFile = fallFile;
	}

	public File getSpringFile() {
		return springFile;
	}

	public void setSpringFile(File springFile) {
		this.springFile = springFile;
	}

	public boolean isComplete() {
		return (summerFile != null && winterFile != null);
	}

	private String getFileContent(File file) {

	    
        // Get the size of the file
        long length = file.length();
    
        if (length > Integer.MAX_VALUE) {
            // File is too large
        }
    
        // Create the byte array to hold the data
        byte[] bytes = new byte[(int)length];
    
        try {
	        InputStream is = new FileInputStream(file);
	
	        // Read in the bytes
	        int offset = 0;
	        int numRead = 0;
	        while (offset < bytes.length
	               && (numRead=is.read(bytes, offset, bytes.length-offset)) >= 0) {
	            offset += numRead;
	        }
	    
	        // Close the input stream and return bytes
	        is.close();
        } catch (IOException e) {
        	
        }

        return new String(bytes);
	}

	public int getActiveSeason() {
		int season = FSXVegModel.NONE;
		
		if (defaultFile != null) {
			
			//System.out.println("Default file hash code: " + getFileContentHash(defaultFile));

			String defaultFileContent = getFileContent(defaultFile);
			
			Vector files = getSeasonalFiles();
			for (int i = 0; i < files.size(); i++) {
				File file = (File) files.get(i);

				String fileContent = getFileContent(file);
				
				if (fileContent.equals(defaultFileContent)) {
					//System.out.println(file.getName());
					
					if (file == summerFile)
						return FSXVegModel.SUMMER;
					if (file == winterFile)
						return FSXVegModel.WINTER;
					if (file == hardWinterFile)
						return FSXVegModel.HARDWINTER;
					if (file == springFile)
						return FSXVegModel.SPRING;
					if (file == fallFile)
						return FSXVegModel.FALL;
				
				}
			}
		} else {
			if (summerFile.getName().substring(summerFile.getName().length()-4).toLowerCase().equals(".bgl")) {
				season = FSXVegModel.SUMMER;
			} 
			
			if (winterFile.getName().substring(winterFile.getName().length()-4).toLowerCase().equals(".bgl")) {
				season = FSXVegModel.WINTER;
			}

			if (hardWinterFile != null && hardWinterFile.getName().substring(hardWinterFile.getName().length()-4).toLowerCase().equals(".bgl")) {
				season = FSXVegModel.HARDWINTER;
			}

			if (springFile != null && springFile.getName().substring(springFile.getName().length()-4).toLowerCase().equals(".bgl")) {
				season = FSXVegModel.SPRING;
			}

			if (fallFile != null && fallFile.getName().substring(fallFile.getName().length()-4).toLowerCase().equals(".bgl")) {
				season = FSXVegModel.FALL;
			}
		
		}
		
		return season;
	}
	
	private Vector getSeasonalFiles() {
		Vector files = new Vector();
		if (summerFile != null)
			files.add(summerFile);
		if (winterFile != null)
			files.add(winterFile);
		if (hardWinterFile != null)
			files.add(hardWinterFile);
		if (springFile != null)
			files.add(springFile);
		if (fallFile != null)
			files.add(fallFile);
		
		return files;
	}
	
	private File getSeasonFileFallback(int season) {
		File returnedFile = summerFile;
		
		switch(season) {
		case FSXVegModel.WINTER:
			returnedFile = winterFile;
			break;
		case FSXVegModel.HARDWINTER:
			if (hardWinterFile != null)
				returnedFile = hardWinterFile;
			else
				returnedFile = winterFile;
			break;
		case FSXVegModel.SPRING:
			if (springFile != null)
				returnedFile = springFile;
			break;
		case FSXVegModel.FALL:
			if (fallFile != null)
				returnedFile = fallFile;
			break;
		}

		return returnedFile;
		
	}

	private void copyFile(File src, File dst) throws IOException {
        InputStream in = new FileInputStream(src);
        OutputStream out = new FileOutputStream(dst);
    
        // Transfer bytes from in to out
        byte[] buf = new byte[1024];
        int len;
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }
	
	
	public boolean setActiveSeason(int season) {

		// First make sure that all seasonal files have the extension b00
		// That is done by checking all the for the extension bgl and if found
		// rename that file to b00:
		
		boolean retval = false;
		
		Vector files = getSeasonalFiles();
		for (int i = 0; i < files.size(); i++) {
			File file = (File) files.get(i);
			String extension = file.getName().substring(file.getName().length()-4);
			if (extension.toLowerCase().equals(".bgl") || extension.equals(".B00")) {
				String newFileName = file.getName().substring(0, file.getName().length()-4) + ".b00";
				File dest = new File(file.getParentFile().getAbsolutePath() + "\\" + newFileName);
				
				//System.out.println("Renaming " + file.getName() + " to " + dest.getName());
				
				if (!file.renameTo(dest)) {
					//System.out.println("Returning false");
					return false;
				} else {
					if (file == summerFile)
						summerFile = dest;
					if (file == winterFile)
						winterFile = dest;
					if (file == hardWinterFile)
						hardWinterFile = dest;
					if (file == springFile)
						springFile = dest;
					if (file == fallFile)
						fallFile = dest;
					
					//System.out.println("Renaming OK. New file name: " + file.getName());
				}
				
			}
		}
		
		// Now copy the content of correct seasonal file into the default bgl file without the seasonal suffix.

		File sourceFile = getSeasonFileFallback(season);
		
		//System.out.println("New source file: " + sourceFile);

		String destFileName = sourceFile.getName().substring(0, sourceFile.getName().length()-7) + ".bgl";
		File destinationFile = new File(sourceFile.getParentFile().getAbsolutePath() + "\\" + destFileName);
		
		//System.out.println("New destination file: " + destinationFile);
		
		try {
			copyFile(sourceFile, destinationFile);
			retval = true;
			defaultFile = destinationFile;
		} catch (IOException e) {
			retval = false;
			
		}
		
		/*
		switch (season) {
		case FSXVegModel.WINTER:
			if (summerFile != null) {
				String newSummerFileName = summerFile.getName().substring(0, summerFile.getName().length()-4) + ".B00";
				File dest = new File(summerFile.getParentFile().getAbsolutePath() + "\\" + newSummerFileName);
				if (!summerFile.renameTo(dest)) {
					return false;
				}
			}

			if (winterFile != null) {
				String newWinterFileName = winterFile.getName().substring(0, winterFile.getName().length()-4) + ".BGL";
				File dest = new File(winterFile.getParentFile().getAbsolutePath() + "\\" + newWinterFileName);
				if (!winterFile.renameTo(dest)) {
					return false;
				}
			}
			
			
			break;
		case FSXVegModel.SUMMER:
			if (winterFile != null) {
				String newWinterFileName = winterFile.getName().substring(0, winterFile.getName().length()-4) + ".B00";
				File dest = new File(winterFile.getParentFile().getAbsolutePath() + "\\" + newWinterFileName);
				if (!winterFile.renameTo(dest)) {
					return false;
				}
			}
			if (summerFile != null) {
				String newSummerFileName = summerFile.getName().substring(0, summerFile.getName().length()-4) + ".BGL";
				File dest = new File(summerFile.getParentFile().getAbsolutePath() + "\\" + newSummerFileName);
				if (!summerFile.renameTo(dest)) {
					return false;
				}
			}


			break;
		}
		return true;
		*/
		return retval;
	}
}
