package dk.clondyke.fsxveg;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class Log {

	private static String logFileName = "fsxveg.txt";
	private static boolean enabled = false;
	
	public static void setEnabled(boolean newEnabled) {
		enabled = newEnabled;
	}
	
	public static void init() {
		if (!enabled)
			return;
		File file = new File(logFileName);

		try {
			file.createNewFile();

		    FileWriter fstream = new FileWriter(file);
	        BufferedWriter out = new BufferedWriter(fstream);
		    out.write("");
		    //Close the output stream
		    out.close();			
			
		} catch (IOException e) {
			e.printStackTrace();
		}		
		
	}
	
	public static void log(String line) {
		if (!enabled)
			return;
		File file = new File(logFileName);

		PrintWriter o = null;
		try {
			if (!file.exists())
				file.createNewFile();
			FileOutputStream out = new FileOutputStream(file, true);
            			
			OutputStreamWriter os = new OutputStreamWriter(out);
			
			BufferedWriter br = new BufferedWriter(os);
			o = new PrintWriter(br);
			o.println(line);
			System.out.println(line);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			if (o != null){
				o.close();
			}
		}		
	}
}
