package dk.clondyke.fsxveg;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.UIManager;

public class FSXVegMainGUI extends JFrame implements ActionListener {
	private FSXVegModel model;
	private FSXVegController controller;
	
	private JTextField pathField;
	private JLabel stateLabel;
	private JPanel mainPanel;
	private JButton summerButton, winterButton, hardWinterButton, springButton, fallButton, showFilesButton;

	public FSXVegMainGUI() {
		super(FSXVegModel.getInstance().getProgramName());

		controller = FSXVegController.getInstance(); 
		model = FSXVegModel.getInstance();
		setOptions();

		try {
			URL iconURL = ClassLoader.getSystemResource("images/icons/32x32/blockdevice.png");
			setIconImage(new ImageIcon(iconURL).getImage());
		} catch (NullPointerException e) {
			e.printStackTrace();
		}
		
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);	
		createAndShowGUI();
		pack();
		setResizable(false);
		setLocation(200, 200);
		
	}

	public static void setOptions() {
		//Options.setPopupDropShadowEnabled(true);
		//Options.setUseSystemFonts(true);

		try {
			UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
		} catch (Exception e) {
			
		}

	}

	private void createAndShowGUI() {
		JPanel outerPanel = new JPanel(new SpringLayout());
		outerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		
		mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());

		JPanel pathSelectPanel = new JPanel(new SpringLayout());

		pathSelectPanel.add(new JLabel("Scenery path: "));
		pathField = new JTextField(40);
		pathField.setEditable(false);
		//pathField.setEnabled(false);
		pathSelectPanel.add(pathField);
		JButton browseButton = new JButton("Browse");
		browseButton.addActionListener(this);
		browseButton.setActionCommand("browseSceneryPath");
		pathSelectPanel.add(browseButton);
		pathSelectPanel.add(new JLabel("Active season: "));
		stateLabel = new JLabel();
		pathSelectPanel.add(stateLabel);
		stateLabel.setText("Summer");
		showFilesButton = new JButton("Show files");
		showFilesButton.setActionCommand("showFiles");
		showFilesButton.addActionListener(this);
		pathSelectPanel.add(showFilesButton);

		SpringUtilities.makeCompactGrid(pathSelectPanel, 2, 3, //rows, cols
				2, 2, //initX, initY
				4, 4); //xPad, yPad			
		
		mainPanel.add(pathSelectPanel, BorderLayout.NORTH);


		JPanel seasonButtonsPanel = new JPanel(new SpringLayout());
		seasonButtonsPanel.setBorder(BorderFactory.createTitledBorder("Select active season"));
		
		JPanel bottomPanel1 = new JPanel();

		springButton = new JButton("Spring");
		springButton.setActionCommand("setSpring");
		springButton.addActionListener(controller);
		bottomPanel1.add(springButton);

		summerButton = new JButton("Summer");
		summerButton.setActionCommand("setSummer");
		summerButton.addActionListener(controller);
		summerButton.setEnabled(false);
		bottomPanel1.add(summerButton);

		fallButton = new JButton("Fall");
		fallButton.setActionCommand("setFall");
		fallButton.addActionListener(controller);
		bottomPanel1.add(fallButton);

		winterButton = new JButton("Winter");
		winterButton.setActionCommand("setWinter");
		winterButton.addActionListener(controller);
		bottomPanel1.add(winterButton);
		
		hardWinterButton = new JButton("Hard winter");
		hardWinterButton.setActionCommand("setHardWinter");
		hardWinterButton.addActionListener(controller);
		bottomPanel1.add(hardWinterButton);
		

		seasonButtonsPanel.add(bottomPanel1);
		//seasonButtonsPanel.add(bottomPanel2);
		
		SpringUtilities.makeCompactGrid(seasonButtonsPanel, 1, 1, //rows, cols
				2, 2, //initX, initY
				4, 4); //xPad, yPad			
		
		
		
		mainPanel.add(seasonButtonsPanel);

		outerPanel.add(mainPanel);
		SpringUtilities.makeCompactGrid(outerPanel, 1, 1, //rows, cols
				2, 2, //initX, initY
				4, 4); //xPad, yPad			
		
		
		setContentPane(outerPanel);
	}

    public void actionPerformed(ActionEvent e) {
    	//	System.out.println("Action command: " + e.getActionCommand());
    	if (e.getActionCommand().equals("browseSceneryPath")) {
    		openDirSelect();
    	}
    	if (e.getActionCommand().equals("showFiles")) {
    		showFiles();
    	}
    }
	
    public void updateDataState() {
    	pathField.setText(model.getSceneryPath());
    	if (model.getState() == FSXVegModel.SUMMER) {
    		stateLabel.setText("Summer");
    		summerButton.setEnabled(false);
    		winterButton.setEnabled(true);
    		hardWinterButton.setEnabled(true);
    		springButton.setEnabled(true);
    		fallButton.setEnabled(true);
    	}
    	if (model.getState() == FSXVegModel.WINTER) {
    		stateLabel.setText("Winter");
    		summerButton.setEnabled(true);
    		winterButton.setEnabled(false);
    		hardWinterButton.setEnabled(true);
    		springButton.setEnabled(true);
    		fallButton.setEnabled(true);
    	}
    	if (model.getState() == FSXVegModel.HARDWINTER) {
    		stateLabel.setText("Hard winter");
    		summerButton.setEnabled(true);
    		winterButton.setEnabled(true);
    		hardWinterButton.setEnabled(false);
    		springButton.setEnabled(true);
    		fallButton.setEnabled(true);
    	}
    	if (model.getState() == FSXVegModel.SPRING) {
    		stateLabel.setText("Spring");
    		summerButton.setEnabled(true);
    		winterButton.setEnabled(true);
    		hardWinterButton.setEnabled(true);
    		springButton.setEnabled(false);
    		fallButton.setEnabled(true);
    	}
    	if (model.getState() == FSXVegModel.FALL) {
    		stateLabel.setText("Fall");
    		summerButton.setEnabled(true);
    		winterButton.setEnabled(true);
    		hardWinterButton.setEnabled(true);
    		springButton.setEnabled(true);
    		fallButton.setEnabled(false);
    	}
    	if (model.getState() == FSXVegModel.MIXED) {
    		stateLabel.setText("Mixed (" + model.getActiveSeasonsAsString() + ")");
    		summerButton.setEnabled(true);
    		winterButton.setEnabled(true);
    		hardWinterButton.setEnabled(true);
    		springButton.setEnabled(true);
    		fallButton.setEnabled(true);
    	}
    	if (model.getState() == FSXVegModel.NONE) {
    		stateLabel.setText("None");
    		summerButton.setEnabled(true);
    		winterButton.setEnabled(true);
    		hardWinterButton.setEnabled(true);
    		springButton.setEnabled(true);
    		fallButton.setEnabled(true);
    	}
    	if (model.getState() == FSXVegModel.EXCEPTION) {
    		stateLabel.setText(model.getExceptionMessage());
    		summerButton.setEnabled(false);
    		winterButton.setEnabled(false);
    		hardWinterButton.setEnabled(false);
    		springButton.setEnabled(false);
    		fallButton.setEnabled(false);
    	}
    	showFilesButton.setEnabled(!model.getFilesToString().equals(""));
    	
    }
	
    private void showFiles() {
    	String files = model.getFilesToString();
    	JOptionPane.showMessageDialog(this, files, "Files", JOptionPane.INFORMATION_MESSAGE);
    }
    
	private void openDirSelect() {
		JFileChooser chooser = new JFileChooser();
		if (pathField.getText() != "") {
			File selectedDir = new File(pathField.getText() + "\\");
			chooser.setSelectedFile(selectedDir);
		}
		chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		chooser.setDialogTitle("Directories");
		chooser.setApproveButtonText("Select directory");
		int returnVal = chooser.showOpenDialog(this);
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			File dir = chooser.getSelectedFile();
			controller.setSceneryPath(dir.getAbsolutePath());
		}
	}

}
