package dk.clondyke.fsxveg;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;

public class FSXVegController implements ActionListener {
	private static FSXVegController instance = null;
	private FSXVegModel model = null;
	private FSXVegMainGUI mainGUI = null;
	
	private FSXVegController() {
		
	}
	
	public static FSXVegController getInstance() {
		if (instance == null) {
			instance = new FSXVegController(); 
		}
		return instance;
	}
	
	public void runProgram() {
		model = FSXVegModel.getInstance();
		mainGUI = new FSXVegMainGUI();
		mainGUI.updateDataState();
		
		mainGUI.setVisible(true);
		if (model.atLeastOneSetHasSuffix()) {
			notifyFSXShouldNotBeRunning();
		}
	}
	
	public static void main(String args[]) {
		FSXVegController program = FSXVegController.getInstance();
		program.runProgram();
	}

	public void setSceneryPath(String newPath) {
		model.setSceneryPath(newPath);
		mainGUI.updateDataState();
		if (model.atLeastOneSetHasSuffix()) {
			notifyFSXShouldNotBeRunning();
		}
	}
	
	private void notifyFSXShouldNotBeRunning() {
		JOptionPane.showMessageDialog(null, "This tool will rearrange the files in the scenery directory that have seasonal dependencies.\n" +
									"In this first run the files will be renamed, which is not possible if FSX is running at the same time.\n" +
									"Therefore you must make sure that FSX is not running.\n\n" +
									"After this you can have FSX running while using this tool to change seasons, but you will still \n" +
									"need to reload the scenery from within FSX to see the changes (World -> Scenery Library -> OK)");
	}
	
	public void actionPerformed(ActionEvent e) {
	//	System.out.println("Action command: " + e.getActionCommand());
    	if (e.getActionCommand().equals("setWinter")) {
    		model.setActiveSeason(FSXVegModel.WINTER);
    		mainGUI.updateDataState();
    	}
    	if (e.getActionCommand().equals("setSummer")) {
    		model.setActiveSeason(FSXVegModel.SUMMER);
    		mainGUI.updateDataState();
    	}
    	if (e.getActionCommand().equals("setHardWinter")) {
    		model.setActiveSeason(FSXVegModel.HARDWINTER);
    		mainGUI.updateDataState();
    	}
    	if (e.getActionCommand().equals("setSpring")) {
    		model.setActiveSeason(FSXVegModel.SPRING);
    		mainGUI.updateDataState();
    	}
    	if (e.getActionCommand().equals("setFall")) {
    		model.setActiveSeason(FSXVegModel.FALL);
    		mainGUI.updateDataState();
    	}
    }
}
